<?php
// includes/auth.php
session_start();

// CSRF
if (empty($_SESSION['csrf_token'])) {
  $_SESSION['csrf_token'] = bin2hex(random_bytes(32));
}
function csrf_field() {
  $t = htmlspecialchars($_SESSION['csrf_token'] ?? '', ENT_QUOTES, 'UTF-8');
  echo "<input type=\"hidden\" name=\"csrf_token\" value=\"{$t}\">";
}
function verify_csrf() {
  if (!isset($_POST['csrf_token']) || !hash_equals($_SESSION['csrf_token'] ?? '', $_POST['csrf_token'])) {
    http_response_code(403);
    die("CSRF token tidak valid.");
  }
}

function is_logged_in() { return !empty($_SESSION['user']); }
function require_login() {
  if (!is_logged_in()) {
    header("Location: login.php");
    exit;
  }
}
function current_user() { return $_SESSION['user'] ?? null; }
function user_role() { return $_SESSION['user']['role'] ?? 'wali'; }
