<?php
require __DIR__ . '/../config/db.php';
require __DIR__ . '/../includes/auth.php';
require __DIR__ . '/../includes/rbac.php';
require_login(); require_role(['admin','guru']);
require __DIR__ . '/../includes/header.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  verify_csrf();
  $santri_id = (int)($_POST['santri_id'] ?? 0);
  $tanggal = $_POST['tanggal'] ?? date('Y-m-d');
  $status = $_POST['status'] ?? 'H';
  if ($santri_id) {
    $stmt = $pdo->prepare("INSERT INTO absensi(santri_id,tanggal,status) VALUES(?,?,?) ON DUPLICATE KEY UPDATE status=VALUES(status)");
    $stmt->execute([$santri_id,$tanggal,$status]);
  }
}
$santri = $pdo->query("SELECT id,nama FROM santri ORDER BY nama")->fetchAll();
$rows = $pdo->query("SELECT a.id, s.nama, a.tanggal, a.status FROM absensi a JOIN santri s ON s.id=a.santri_id ORDER BY a.tanggal DESC, s.nama")->fetchAll();
?>
<h4>Absensi Harian</h4>
<form method="post" class="row g-3 align-items-end mb-3">
  <?php csrf_field(); ?>
  <div class="col-md-5">
    <label class="form-label">Santri</label>
    <select name="santri_id" class="form-select"><?php foreach ($santri as $s): ?><option value="<?= $s['id'] ?>"><?= htmlspecialchars($s['nama']) ?></option><?php endforeach; ?></select>
  </div>
  <div class="col-md-3">
    <label class="form-label">Tanggal</label>
    <input type="date" name="tanggal" class="form-control" value="<?= date('Y-m-d') ?>">
  </div>
  <div class="col-md-2">
    <label class="form-label">Status</label>
    <select name="status" class="form-select">
      <option value="H">Hadir</option>
      <option value="S">Sakit</option>
      <option value="I">Izin</option>
      <option value="A">Alpa</option>
    </select>
  </div>
  <div class="col-md-2"><button class="btn btn-primary w-100">Simpan</button></div>
</form>
<div class="table-responsive">
<table class="table table-striped">
  <thead><tr><th>Santri</th><th>Tanggal</th><th>Status</th></tr></thead>
  <tbody>
  <?php foreach ($rows as $r): ?>
    <tr>
      <td><?= htmlspecialchars($r['nama']) ?></td>
      <td><?= htmlspecialchars($r['tanggal']) ?></td>
      <td><?= htmlspecialchars($r['status']) ?></td>
    </tr>
  <?php endforeach; ?>
  </tbody>
</table>
</div>
<?php require __DIR__ . '/../includes/footer.php'; ?>
