<?php
require __DIR__ . '/../config/db.php';
require __DIR__ . '/../includes/auth.php';
require __DIR__ . '/../includes/rbac.php';
require_login(); require_role(['admin','guru']);
require __DIR__ . '/../includes/header.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  verify_csrf();
  $santri_id = (int)($_POST['santri_id'] ?? 0);
  $wali_id = (int)($_POST['wali_id'] ?? 0);
  if ($santri_id && $wali_id) {
    $pdo->prepare("INSERT IGNORE INTO santri_wali(santri_id,wali_id) VALUES(?,?)")->execute([$santri_id,$wali_id]);
  }
}
if (isset($_GET['remove'])) {
  $id = (int)$_GET['remove'];
  $pdo->prepare("DELETE FROM santri_wali WHERE id=?")->execute([$id]);
  header("Location: relasi_list.php"); exit;
}
$santri = $pdo->query("SELECT id,nama FROM santri ORDER BY nama")->fetchAll();
$wali = $pdo->query("SELECT id,nama FROM wali ORDER BY nama")->fetchAll();
$rels = $pdo->query("SELECT sw.id, s.nama AS santri, w.nama AS wali FROM santri_wali sw JOIN santri s ON s.id=sw.santri_id JOIN wali w ON w.id=sw.wali_id ORDER BY s.nama,w.nama")->fetchAll();
?>
<h4>Relasi Santri ↔ Wali</h4>
<form method="post" class="row g-3 align-items-end mb-3">
  <?php csrf_field(); ?>
  <div class="col-md-5">
    <label class="form-label">Santri</label>
    <select name="santri_id" class="form-select"><?php foreach ($santri as $s): ?><option value="<?= $s['id'] ?>"><?= htmlspecialchars($s['nama']) ?></option><?php endforeach; ?></select>
  </div>
  <div class="col-md-5">
    <label class="form-label">Wali</label>
    <select name="wali_id" class="form-select"><?php foreach ($wali as $w): ?><option value="<?= $w['id'] ?>"><?= htmlspecialchars($w['nama']) ?></option><?php endforeach; ?></select>
  </div>
  <div class="col-md-2">
    <button class="btn btn-primary w-100">Tambah</button>
  </div>
</form>
<div class="table-responsive">
<table class="table table-striped">
  <thead><tr><th>Santri</th><th>Wali</th><th>Aksi</th></tr></thead>
  <tbody>
    <?php foreach ($rels as $r): ?>
      <tr>
        <td><?= htmlspecialchars($r['santri']) ?></td>
        <td><?= htmlspecialchars($r['wali']) ?></td>
        <td><a class="btn btn-sm btn-outline-danger" href="?remove=<?= $r['id'] ?>" onclick="return confirm('Hapus relasi?')">Hapus</a></td>
      </tr>
    <?php endforeach; ?>
  </tbody>
</table>
</div>
<?php require __DIR__ . '/../includes/footer.php'; ?>
