<?php
// public/index.php
require __DIR__ . '/../config/db.php';
require __DIR__ . '/../includes/auth.php';
require __DIR__ . '/../includes/rbac.php';
require __DIR__ . '/../includes/header.php';

if (!is_logged_in()) {
  echo '<div class="text-center py-5"><h3>Selamat datang di Sistem TPQ Al-Washil</h3><p>Silakan login untuk melanjutkan.</p><a class="btn btn-primary" href="login.php">Login</a></div>';
  require __DIR__ . '/../includes/footer.php'; exit;
}

$role = user_role();
?>
<div class="row g-3">
  <div class="col-md-4">
    <div class="card h-100">
      <div class="card-body">
        <h5 class="card-title">Ringkasan</h5>
        <?php
          $santri = $pdo->query("SELECT COUNT(*) c FROM santri")->fetch()['c'] ?? 0;
          $wali = $pdo->query("SELECT COUNT(*) c FROM wali")->fetch()['c'] ?? 0;
          $pengumuman = $pdo->query("SELECT COUNT(*) c FROM pengumuman")->fetch()['c'] ?? 0;
        ?>
        <ul class="list-group">
          <li class="list-group-item d-flex justify-content-between align-items-center">
            Total Santri <span class="badge text-bg-primary"><?= $santri ?></span>
          </li>
          <li class="list-group-item d-flex justify-content-between align-items-center">
            Total Wali <span class="badge text-bg-primary"><?= $wali ?></span>
          </li>
          <li class="list-group-item d-flex justify-content-between align-items-center">
            Pengumuman <span class="badge text-bg-primary"><?= $pengumuman ?></span>
          </li>
        </ul>
      </div>
    </div>
  </div>
  <div class="col-md-8">
    <div class="card h-100">
      <div class="card-body">
        <h5 class="card-title">Aktivitas Terbaru</h5>
        <p>Gunakan menu di atas untuk mengelola data.</p>
      </div>
    </div>
  </div>
</div>
<?php require __DIR__ . '/../includes/footer.php'; ?>
